package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.dao.ComunicacionPrlDao;
import com.ejie.ab04b.model.ComunicacionPrl;
import com.ejie.ab04b.model.DatosAviso;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.service.nora.LocalidadService;
import com.ejie.ab04b.service.nora.MunicipioService;
import com.ejie.ab04b.service.nora.ProvinciaService;
import com.ejie.ab04b.service.platea.ReeService;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ComunicacionPrlServiceImpl generated by UDA, 23-feb-2017 13:09:26.
 * 
 * @author UDA
 */

@Service(value = "comunicacionPrlService")
public class ComunicacionPrlServiceImpl implements ComunicacionPrlService {

	@Autowired()
	private ComunicacionPrlDao comunicacionPrlDao;

	@Autowired()
	private ReeService reeService;

	@Autowired()
	private DatosNotificacionService datosNotificacionService;

	@Autowired()
	private DatosLocalizacionService datosLocalizacionService;

	@Autowired()
	private DatosAvisoService datosAvisoService;

	@Autowired()
	private OS2Service oS2Service;

	@Autowired()
	private OS3Service oS3Service;

	@Autowired()
	private LocalidadService localidadService;

	@Autowired()
	private ProvinciaService provinciaService;

	@Autowired()
	private MunicipioService municipioService;

	/**
	 * Inserts a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl ComunicacionPrl
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the comunicacion prl
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionPrl add(ComunicacionPrl comunicacionPrl) {
		return this.comunicacionPrlDao.add(comunicacionPrl);
	}

	/**
	 * Updates a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl ComunicacionPrl
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the comunicacion prl
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ComunicacionPrl update(ComunicacionPrl comunicacionPrl) {
		return this.comunicacionPrlDao.update(comunicacionPrl);
	}

	/**
	 * Finds a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl ComunicacionPrl
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the comunicacion prl
	 */
	public ComunicacionPrl find(ComunicacionPrl comunicacionPrl) {
		return (ComunicacionPrl) this.comunicacionPrlDao.find(comunicacionPrl);
	}

	/**
	 * Finds a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto filtro
	 * ComunicacionPrl ComunicacionPrl
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param filtro
	 *            the filtro
	 * @return the comunicacion prl
	 */
	public ComunicacionPrl findDetalle(ComunicacionPrl comunicacionPrl,
			JQGridRequestDto jqGridRequestDto, ComunicacionPrl filtro) {
		return (ComunicacionPrl) this.comunicacionPrlDao
				.vistaFindDetalle(comunicacionPrl, jqGridRequestDto, filtro);
	}

	/**
	 * Finds a single row in the ComunicacionPrl table.
	 * 
	 * prl ComunicacionPrl ComunicacionPrl
	 *
	 * @param prl
	 *            the prl
	 * @return the comunicacion prl
	 */
	public ComunicacionPrl findComunicacionPrlConNotificacion(
			ComunicacionPrl prl) {

		ComunicacionPrl comunicacionPrl = this.comunicacionPrlDao.find(prl);

		// miramos si es la primera vez que se consulta y aun no tiene guardados
		// los datos de notificacion
		if (comunicacionPrl.getFolderId() != null
				&& (comunicacionPrl.getDatosNotificacion() == null
						|| comunicacionPrl.getDatosNotificacion()
								.getCodDatosNotif066() == null
						|| comunicacionPrl.getDatosNotificacion()
								.getCodDatosNotif066() == 0)) {
			DatosNotificacion datosNotifFolderId = this.reeService
					.obtenerDatosNotificacionExpedienteREE(
							comunicacionPrl.getFolderId(), (Constantes.VALUE_SI
									.equals(comunicacionPrl.getMigrado())));

			if (datosNotifFolderId != null) {
				// los volcamos a nuestra bd

				comunicacionPrl.setDatosNotificacion(new DatosNotificacion());
				comunicacionPrl.getDatosNotificacion().setCanalnotif066(
						datosNotifFolderId.getCanalnotif066());
				if (Constantes.LOCALE_ES
						.equals(LocaleContextHolder.getLocale())) {
					comunicacionPrl.getDatosNotificacion()
							.setIdioma066(Constantes.IDIOMA_NOTIF_CASTELLANO);
				} else if (Constantes.LOCALE_EU
						.equals(LocaleContextHolder.getLocale())) {
					comunicacionPrl.getDatosNotificacion()
							.setIdioma066(Constantes.IDIOMA_NOTIF_EUSKERA);
				}

				if (Constantes.CANAL_NOTIF_POSTAL
						.equals(datosNotifFolderId.getCanalnotif066())) {
					DatosLocalizacion dl = datosNotifFolderId
							.getDatosLocalizacion();

					Provincia prov = dl.getProvincia();
					Municipio mun = dl.getMunicipio();

					if (dl.getLocalidad().getCodLocalidad() == null) {

						if (dl.getProvincia().getDescripcion() != null) {
							prov = provinciaService.findAllFirst(new Provincia(
									null, dl.getProvincia().getDescripcion(),
									null));
						}

						if (dl.getMunicipio().getDescripcion() != null) {
							mun = municipioService.findAllFirst(new Municipio(
									prov.getCodProvincia(), null,
									dl.getMunicipio().getDescripcion()));
						}

						dl.setProvincia(prov);
						dl.setMunicipio(mun);

						Localidad loc = localidadService.findAllFirst(
								new Localidad(prov.getCodProvincia(),
										mun.getCodMunicipio(), null,
										dl.getLocalidad().getDescripcion()));

						Localidad fin = dl.getLocalidad();
						fin.setCodLocalidad(loc.getCodLocalidad());
						dl.setLocalidad(fin);
					}

					dl = datosLocalizacionService.add(dl);

					comunicacionPrl.getDatosNotificacion()
							.setDatosLocalizacion(dl);
				}

				// Los datos de notificación no existen. Los insertamos
				DatosNotificacion datosNotif = this.datosNotificacionService
						.add(comunicacionPrl.getDatosNotificacion());
				comunicacionPrl.setDatosNotificacion(datosNotif);

				if ("OS2".equals(comunicacionPrl.getTipoos())) {
					OS2 os2 = this.oS2Service.modificarDatosTabNotificacionOS2(
							comunicacionPrl, true);
					comunicacionPrl
							.setDatosNotificacion(os2.getDatosNotificacion());
				} else {
					OS3 os3 = this.oS3Service.modificarDatosTabNotificacionOS3(
							comunicacionPrl, true);
					comunicacionPrl
							.setDatosNotificacion(os3.getDatosNotificacion());
				}
				if (Constantes.CANAL_NOTIF_TELEMATICO
						.equals(datosNotifFolderId.getCanalnotif066())) {
					for (DatosAviso da : datosNotifFolderId
							.getListaDatosAviso()) {
						da.setDatosNotificacion(
								comunicacionPrl.getDatosNotificacion());
						da = datosAvisoService.add(da);
					}
				}
			}
		} else {
			DatosNotificacion datosNotificacionYAviso = this.datosNotificacionService
					.findConLocalizacionYAvisos(
							comunicacionPrl.getDatosNotificacion());

			if (datosNotificacionYAviso != null) {
				comunicacionPrl.setDatosNotificacion(datosNotificacionYAviso);
			}

			if (comunicacionPrl.getDatosNotificacion()
					.getDatosLocalizacion() == null) {
				comunicacionPrl.getDatosNotificacion()
						.setDatosLocalizacion(new DatosLocalizacion());
			}
		}

		return comunicacionPrl;
	}

	/**
	 * Deletes a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ComunicacionPrl comunicacionPrl) {
		this.comunicacionPrlDao.remove(comunicacionPrl);
	}

	/**
	 * Finds a list of rows in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto List
	 * <ComunicacionPrl>
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<ComunicacionPrl> findAll(ComunicacionPrl comunicacionPrl,
			JQGridRequestDto jqGridRequestDto) {
		return (List<ComunicacionPrl>) this.comunicacionPrlDao
				.findAll(comunicacionPrl, jqGridRequestDto);
	}

	/**
	 * Finds rows in the ComunicacionPrl table using like.
	 * 
	 * comunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean List<ComunicacionPrl>
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<ComunicacionPrl> findAllLike(ComunicacionPrl comunicacionPrl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<ComunicacionPrl>) this.comunicacionPrlDao
				.findAllLike(comunicacionPrl, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the ComunicacionPrl table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 *
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	public void removeMultiple(ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.comunicacionPrlDao.removeMultiple(filterComunicacionPrl,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the ComunicacionPrl table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean JQGridResponseDto<ComunicacionPrl>
	 *
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ComunicacionPrl> filter(
			ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<ComunicacionPrl> listaComunicacionPrl = this.comunicacionPrlDao
				.findAllLike(filterComunicacionPrl, jqGridRequestDto, false);
		Long recordNum = this.comunicacionPrlDao
				.findAllLikeCount(filterComunicacionPrl != null
						? filterComunicacionPrl : new ComunicacionPrl(), false);
		// if (jqGridRequestDto.getMultiselection().getSelectedIds()!=null){
		// List< TableRowDto< ComunicacionPrl>> reorderSelection =
		// this.comunicacionPrlDao.reorderSelection(filterComunicacionPrl,
		// jqGridRequestDto, startsWith);
		// return new JQGridResponseDto<ComunicacionPrl>(jqGridRequestDto,
		// recordNum, listaComunicacionPrl, reorderSelection);
		// }
		return new JQGridResponseDto<ComunicacionPrl>(jqGridRequestDto,
				recordNum, listaComunicacionPrl);
	}

	/**
	 * Searches rows in the ComunicacionPrl table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl searchComunicacionPrl
	 * ComunicacionPrl jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<ComunicacionPrl>>
	 *
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param searchComunicacionPrl
	 *            the search comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<ComunicacionPrl>> search(
			ComunicacionPrl filterComunicacionPrl,
			ComunicacionPrl searchComunicacionPrl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.comunicacionPrlDao.search(filterComunicacionPrl,
				searchComunicacionPrl, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in ComunicacionPrl table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean Object
	 *
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.comunicacionPrlDao.reorderSelection(filterComunicacionPrl,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the ComunicacionPrl table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean JQGridResponseDto<JerarquiaDto<ComunicacionPrl>>
	 *
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<ComunicacionPrl>> jerarquia(
			ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<ComunicacionPrl>> listaComunicacionPrl = this.comunicacionPrlDao
				.findAllLikeJerarquia(filterComunicacionPrl, jqGridRequestDto);
		Long recordNum = this.comunicacionPrlDao.findAllLikeCountJerarquia(
				filterComunicacionPrl, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<ComunicacionPrl>>(
				jqGridRequestDto, recordNum, listaComunicacionPrl);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the ComunicacionPrl
	 * table.
	 * 
	 * filterComunicacionPrl ComunicacionPrl jqGridRequestDto JQGridRequestDto
	 * JQGridResponseDto<JerarquiaDto<ComunicacionPrl>>
	 *
	 * @param filterComunicacionPrl
	 *            the filter comunicacion prl
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<ComunicacionPrl>> jerarquiaChildren(
			ComunicacionPrl filterComunicacionPrl,
			JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<ComunicacionPrl>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<ComunicacionPrl>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.comunicacionPrlDao.findAllChild(filterComunicacionPrl,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Finds a single row in the ComunicacionPrl table.
	 * 
	 * comunicacionPrl ComunicacionPrl ComunicacionPrl
	 *
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @return the list
	 */
	public List<ComunicacionPrl> findEmpresa(ComunicacionPrl comunicacionPrl) {
		return this.comunicacionPrlDao.findEmpresa(comunicacionPrl);
	}

	/**
	 * Valida que el CP pertenezca a la localidad
	 *
	 * @param comunicacionPrl
	 *            ComunicacionPrl
	 * @return boolean
	 */
	public boolean validaLocalidadCP(ComunicacionPrl comunicacionPrl) {

		Long recordNum = this.comunicacionPrlDao
				.findCPenLocalidadCount(comunicacionPrl);

		return recordNum > 0;

	}

}
